\version "2.18.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  %ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Moș Crăciun"
  subtitle = " "
  %subsubtitle = "Op. 19"
  %poet = ""
  composer = \markup \center-column {"Rumänische Katholische Mission"
  \small "München" }
  %arranger = "io"
  %meter = "nu prea încet"
  tagline=""
}

global = {
  \key g \major
  \autoBeamOff
  %\cadenzaOn
  %\time 6/8
  %\partial 8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Moş Cră -- ciun cu ple -- te dal -- be
  A so -- sit de prin nă -- meţi
  Şi a -- du -- ce da -- ruri mul -- te
  La fe -- ti -- ţe şi bă -- ieţi.
  Moş Cră -- ciun, __ Moş Cră -- ciun.
  
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  Din bă -- trâni se po -- ves -- teş -- te
  Că-n toţi a -- nii ne -- gre -- şit
  Moş Cră -- ciun pri -- beag so -- seş -- te,
  Nici -- o -- da -- tă n-a lip -- sit.
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Moş Cră -- ciun cu ple -- te dal -- be,
  În -- co -- tro vrei s-o a -- puci?
  Ţi-aş cân -- ta "\"Flo" -- ri -- le dal -- "be\","
  De la noi să nu te duci.
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  
}

tenWords = \lyricmode {
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1
  
}

basWordsOne = \lyricmode {
  \set stanza = "1."
    
}

basWordsTwo = \lyricmode {
  \set stanza = "2."
  
}

basWordsThree = \lyricmode {
  \set stanza = "3."
  
}

basWordsFour = \lyricmode {
  \set stanza = "4."
  
}

sopMusic = \relative c' {
  d4 g fis4. d8 e4 fis g d
  d c' h4. g8 a4 a g2
  d4 g fis4. d8 e4 fis g d
  d c' h4. g8 a4 a g2 \bar "||"
  h2 g c1 h2 a g1  
  \bar ":|."
}

altMusic = \relative c' {
  d4 g fis4. d8 e4 fis g d
  d d d4. d8 e4 d8([ c]) h2
  d4 g fis4. d8 e4 fis g d
  d d d4. d8 e4 d8([ c]) h2
  d2 d e( fis) d d4( c) h1
}

tenorMusic = \relative c {
  d4 g fis4. d8 e4 fis g d
  d4 g8([ a]) g4. g8 g4 fis g2
  d4 g fis4. d8 e4 fis g d
  d4 g8([ a]) g4. g8 g4 fis g2
  g2 g g( a) g fis d1
}

bassMusic =  \relative c {
  d4 g fis4. d8 e4 fis g d
  d4 e8([ fis]) g4. h,8 c4 d g,2
  d'4 g fis4. d8 e4 fis g d
  d4 e8([ fis]) g4. h,8 c4 d g,2
  g2 h c( a) d d g,1
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \new Voice { \voiceTwo \global \altMusic }   
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsThree }
     %\new Voice { \voiceTwo \global \altMusic }   
     %\addlyrics { \womenWordsFour }
    >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      %\addlyrics { \tenWords }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \basWordsOne }
      %\addlyrics { \basWordsTwo }
      %\addlyrics { \basWordsThree }  
      %\addlyrics { \basWordsFour } 
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}